#include <SoftwareSerial.h>

/*
  // March 2014 - TMRh20 - Updated along with High Speed RF24 Library fork
  // Parts derived from examples by J. Coliz <maniacbug@ymail.com>
*/
#include <SPI.h>
#include "nRF24L01.h"
#include "RF24.h"
#include "printf.h"
#include <TM1637Display.h>

// Hardware configuration: Set up nRF24L01 radio on SPI bus plus pins 9 & 10
RF24 radio(9, 10);

// Hardware configuration: display communication pin
#define CLK 6
#define DIO 7
#define SEG_DOT   0b10000000

TM1637Display display( CLK, DIO );

//Hardware configuration: bluetooth
SoftwareSerial bluetooth(5,4);    // Rx, Tx

// Topology
const uint64_t pipes[3] = { 0xABCDABCD71LL, 0x544d52687CLL, 0xC08C08687CLL };              // Radio pipe addresses for the 2 nodes to communicate.

long int valoreAttuale = 0;


void setup() {

  Serial.begin(115200);
  printf_begin();
  Serial.println("***************************************");
  Serial.println("        CRONOCURLING DISPLAY");
  Serial.println("***************************************");
  Serial.println("");
  Serial.println("");
 
  // Setup display
  
  display.setBrightness( 0x0c );
  uint8_t data[] = { 0x00, 0x00, 0x00, 0x80 };
  display.setSegments( data );
  
  // Setup and configure rf radio

  radio.begin();
  radio.setAutoAck(1);                    // Ensure autoACK is disabled
  radio.setRetries(0, 3);                // Smallest time between retries, max no. of retries
  radio.openWritingPipe(pipes[1]);        
  radio.openReadingPipe(1, pipes[2]);
  radio.startListening();                 // Start listening
  radio.printDetails();                   // Dump the configuration of the rf unit for debugging

  // Setup bluetooth

  bluetooth.begin(9600);
  
  Serial.println("*** Attesa di un nuovo valore dalle fotocellule");
}

void loop(void) {

  unsigned int risposta;
  byte pipeNo;
  
  while ( radio.available(&pipeNo)) {
      radio.read( &risposta, sizeof(long int) );
      Serial.print(">>>> ricevuto qualcosa: ");
      Serial.println(risposta);

      visualizzaValore(risposta);

      Serial.println("*** Attesa di un nuovo valore dalle fotocellule");
    }
}

void visualizzaValore (long int valore) {

  if (valore == 0) {
    display.showNumberDec(0, false, 4, 0);
    bluetooth.println(valore);
  }
  else {
    if (valore == 8888) {
      //display.showNumberDec(8888, false, 4, 0);
      //uint8_t data[] = { 0x79, 0x79, 0x79, 0x79 };
      uint8_t data[] = { 0x79, SEG_E | SEG_G, SEG_E | SEG_G, 0x00 };
      display.setSegments( data );      //Visualizza EEEE => errore
      bluetooth.println(valore);
    }
    else {
      if (valore < 10)
      {
        bluetooth.println(valore);
        uint8_t data[] = { 0x00, 0x00, 0x00, 0x00 };
        data[1] = display.encodeDigit(0) | SEG_DOT;
        data[2] = display.encodeDigit(0);
        data[3] = display.encodeDigit(0);
        display.setSegments( data );
      }
      else
      {
        valore = valore /10;
        bluetooth.println(valore);
        uint8_t data[] = { 0x00, 0x00, 0x00, 0x00 };
        data[1] = display.encodeDigit(valore/100) | SEG_DOT;
        data[2] = display.encodeDigit(valore%100/10);
        data[3] = display.encodeDigit(valore%10);
        display.setSegments( data );
      }
    }
  }
}


